# Employee Tracker Chrome Extension

A Chrome extension that automatically captures screenshots at random intervals (10-60 seconds) and uploads them to a tracking server.

## Features

- 📸 Automatic screenshot capture at random intervals
- 🔄 Uploads to centralized API endpoint
- 👤 Employee identification and tracking
- ⏱️ Random interval between 10-60 seconds
- 📊 Activity statistics and monitoring
- 🎯 Simple popup interface for control

## Installation

### For Users

1. Download or clone this repository
2. Open Chrome and navigate to `chrome://extensions/`
3. Enable "Developer mode" (toggle in top right)
4. Click "Load unpacked"
5. Select the `extension` folder
6. The extension is now installed and active

### Configuration

1. Click the extension icon in Chrome toolbar
2. Enter your name and email (optional)
3. Click "Save Info"
4. Tracking starts automatically when installed

## Usage

### Controls

- **Start/Stop Tracking**: Toggle screenshot capturing on/off
- **Capture Now**: Immediately capture and upload a screenshot
- **Save Info**: Update your employee information

### Status Information

The popup displays:
- Current tracking status (Active/Inactive)
- Your unique employee ID
- Number of screenshots uploaded
- Last upload time
- Next scheduled capture time

## API Endpoint

The extension sends screenshots to:
```
https://palal.app/api/upload
```

### Data Format

Screenshots are sent as base64-encoded PNG images with metadata:
```json
{
  "employee_id": "unique_employee_id",
  "screenshot_data": "base64_encoded_image",
  "browser_info": "Chrome/120.0.0.0",
  "screen_resolution": "1920x1080",
  "name": "Employee Name",
  "email": "employee@example.com"
}
```

## Permissions

This extension requires the following permissions:
- `tabs`: To access and capture visible tabs
- `activeTab`: To capture the currently active tab
- `storage`: To store employee information and settings
- `desktopCapture`: To capture screenshots
- `host_permissions`: To communicate with the API server

## Privacy Notice

This extension captures screenshots of your active browser window at random intervals. All screenshots are uploaded to the configured server. By using this extension, you acknowledge and consent to this monitoring.

## Development

### File Structure
```
extension/
├── manifest.json       # Extension configuration
├── background.js       # Service worker for screenshot capture
├── popup.html         # Popup interface
├── popup.css          # Popup styling
├── popup.js           # Popup functionality
├── icons/             # Extension icons
└── README.md          # This file
```

### Testing

1. Load the extension in developer mode
2. Open a browser tab
3. Check console logs in background service worker
4. Verify screenshots are being captured and uploaded

### Debugging

- View background script logs: `chrome://extensions/` → Click "service worker"
- View popup logs: Right-click extension icon → "Inspect popup"

## Troubleshooting

**Extension not capturing screenshots:**
- Ensure you have granted all required permissions
- Check if tracking is enabled in the popup
- Verify the API endpoint is accessible

**Screenshots not uploading:**
- Check network connectivity
- Verify API server is running
- Check browser console for error messages

**Random interval not working:**
- Reload the extension
- Check background service worker is active

## Support

For issues or questions, please contact your system administrator.

## License

Proprietary - For internal use only
