// Content script for palal.app
// Bridges communication between web pages and the extension

// Listen for messages from the web page
window.addEventListener('message', (event) => {
  // Only accept messages from palal.app
  if (event.origin !== 'https://palal.app') {
    return;
  }

  // Forward message to background script
  if (event.data.action) {
    chrome.runtime.sendMessage(event.data, (response) => {
      // Send response back to web page
      window.postMessage({
        type: 'FROM_EXTENSION',
        action: event.data.action,
        response: response
      }, 'https://palal.app');
    });
  }
});

// Listen for messages from popup/background to access page's localStorage
chrome.runtime.onMessage.addListener((request, sender, sendResponse) => {
  if (request.action === 'get_local_storage') {
    // Access localStorage from page context
    const authData = {
      auth_token: localStorage.getItem('auth_token'),
      user_id: localStorage.getItem('user_id'),
      user_name: localStorage.getItem('user_name'),
      user_email: localStorage.getItem('user_email'),
      company_id: localStorage.getItem('company_id'),
      company_name: localStorage.getItem('company_name'),
      company_slug: localStorage.getItem('company_slug')
    };
    sendResponse(authData);
    return true;
  }
});

// Inject the bridge script into the page context
const script = document.createElement('script');
script.src = chrome.runtime.getURL('inject.js');
(document.head || document.documentElement).appendChild(script);
script.onload = () => script.remove();

console.log('Employee Tracker content script loaded');
